require "brains/hallucinationbrain"
require "stategraphs/SGshadowwaxwell"

local assets = 
{
    Asset("ANIM", "anim/shadowkyle.zip"),
    Asset("ANIM", "anim/shadowheather.zip"),
	Asset("SOUND", "sound/maxwell.fsb"),
	Asset("ANIM", "anim/swap_pickaxe.zip"),
	Asset("ANIM", "anim/swap_axe.zip"),
	Asset("ANIM", "anim/swap_nightmaresword.zip"),
}

local prefabs = 
{
    "nightmarefuel",
}

SetSharedLootTable( 'schizo_friend',
{
    {'nightmarefuel',  0.75},
})

local items =
{
	AXE = "swap_axe",
	PICK = "swap_pickaxe",
    SWORD = "swap_nightmaresword"
}

local builds = {"shadowkyle", "shadowheather"}

local function EquipItem(inst, item)
	if item then
	    inst.AnimState:OverrideSymbol("swap_object", item, item)
	    inst.AnimState:Show("ARM_carry") 
	    inst.AnimState:Hide("ARM_normal")
	end
end

local function die(inst)
	inst.components.health:Kill()
end

local function resume(inst, time)
    if inst.death then
        inst.death:Cancel()
        inst.death = nil
    end
    inst.death = inst:DoTaskInTime(time, die)
end

local function onsave(inst, data)
    data.timeleft = (inst.lifetime - inst:GetTimeAlive())
	data.build = inst.build
end

local function KeepTarget(isnt, target)
    return target and target:IsValid()
end

local function onload(inst, data)
    if data.timeleft then
        inst.lifetime = data.timeleft
        if inst.lifetime > 0 then
            resume(inst, inst.lifetime)
        else
            die(inst)
        end
    end
	
	if data then
		inst.build = data.build or builds[1]
			inst.AnimState:SetBuild(inst.build)
	end
end
		
local function entitydeathfn(inst, data)
    if data.inst:HasTag("player") then
        inst:DoTaskInTime(math.random(), function() inst.components.health:Kill() end)
    end
end

local function FollowPlayer(inst)
	local player = GetPlayer()
	if player and player.components.leader then
		player.components.leader:AddFollower(inst)
	end
end

local function die(inst)
	inst.components.health:Kill()
end

local function SetHallucination(inst)

	inst.AnimState:SetBuild(inst.build)	
		
	inst.components.sanityaura.aura = (TUNING.SANITYAURA_TINY)
		
	inst:AddTag("schizofight")
    inst:AddComponent("combat")
	inst.components.combat.hiteffectsymbol = "torso"
	-- inst.components.combat:SetRetargetFunction(1, Retarget)
	inst.components.combat:SetKeepTargetFunction(KeepTarget)
	inst.components.combat:SetAttackPeriod(3)
	inst.components.combat:SetRange(2, 3)
	inst.components.combat:SetDefaultDamage(30)
	
	inst.components.health:SetMaxHealth(250)
	inst.components.health:StartRegen(2, 1)
	inst.components.health.nofadeout = true

	return inst
end

local function common()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()

	inst.Transform:SetFourFaced(inst)

	MakeGhostPhysics(inst, 1, .5)
	
	anim:SetBank("wilson")

    anim:Hide("ARM_carry")
    anim:Hide("hat")
    anim:Hide("hat_hair")
	
	anim:PlayAnimation("idle")

    inst:AddTag("companion")
	inst:AddTag("hallucination")
	
	inst:AddComponent("colourtweener")
	inst.components.colourtweener:StartTween({0,0,0,.5}, 0)

	inst:AddComponent("locomotor")
    inst.components.locomotor.pathcaps = { ignorecreep = true }
    inst.components.locomotor.runspeed = 12
	
    inst:AddComponent("follower")
	FollowPlayer(inst)

    inst:AddComponent("health")

	inst:AddComponent("inventory")
    inst.components.inventory.dropondeath = true
	
	inst:AddComponent("lootdropper")
    inst.components.lootdropper:SetChanceLootTable('shadow_creature')

	inst:AddComponent("sanityaura")

    inst.items = items
    inst.equipfn = EquipItem

    inst.OnSave = onsave
    inst.OnLoad = onload
	
	inst.lifetime = (TUNING.SHADOWWAXWELL_LIFETIME * 3)
	inst.death = inst:DoTaskInTime(inst.lifetime, die)

    EquipItem(inst)

    inst:ListenForEvent("entity_death", function(world, data) entitydeathfn(inst, data) end, GetWorld())

	local brain = require"brains/hallucinationbrain"
	inst:SetBrain(brain)
	inst:SetStateGraph("SGshadowwaxwell")

	return inst
end

local function hallucination()
    local inst = common()
    inst.build = builds[math.random(#builds)]
    inst.AnimState:SetBuild(inst.build)
    SetHallucination(inst)
    return inst
end

return Prefab("common/schizo_friend", hallucination, assets, prefabs)